/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata;

import java.util.Objects;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.util.Assert;

public class OpenAiImageResponseMetadata
implements ImageResponseMetadata {
    private final Long created;

    public static OpenAiImageResponseMetadata from(OpenAiImageApi.OpenAiImageResponse openAiImageResponse) {
        Assert.notNull((Object)openAiImageResponse, (String)"OpenAiImageResponse must not be null");
        return new OpenAiImageResponseMetadata(openAiImageResponse.created());
    }

    protected OpenAiImageResponseMetadata(Long created) {
        this.created = created;
    }

    public Long created() {
        return this.created;
    }

    public String toString() {
        return "OpenAiImageResponseMetadata{created=" + this.created + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenAiImageResponseMetadata)) {
            return false;
        }
        OpenAiImageResponseMetadata that = (OpenAiImageResponseMetadata)o;
        return Objects.equals(this.created, that.created);
    }

    public int hashCode() {
        return Objects.hash(this.created);
    }
}

