/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.azure.openai;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.util.ClientOptions;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiChatProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiConnectionProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiEmbeddingProperties;
import org.springframework.ai.azure.openai.AzureOpenAiChatClient;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

@AutoConfiguration
@ConditionalOnClass(value={OpenAIClientBuilder.class})
@EnableConfigurationProperties(value={AzureOpenAiChatProperties.class, AzureOpenAiEmbeddingProperties.class, AzureOpenAiConnectionProperties.class})
public class AzureOpenAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OpenAIClient openAIClient(AzureOpenAiConnectionProperties connectionProperties) {
        Assert.hasText((String)connectionProperties.getApiKey(), (String)"API key must not be empty");
        Assert.hasText((String)connectionProperties.getEndpoint(), (String)"Endpoint must not be empty");
        return new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential((KeyCredential)new AzureKeyCredential(connectionProperties.getApiKey())).clientOptions(new ClientOptions().setApplicationId("spring-ai")).buildClient();
    }

    @Bean
    public AzureOpenAiChatClient azureOpenAiChatClient(OpenAIClient openAIClient, AzureOpenAiChatProperties chatProperties) {
        AzureOpenAiChatClient azureOpenAiChatClient = new AzureOpenAiChatClient(openAIClient, chatProperties.getOptions());
        return azureOpenAiChatClient;
    }

    @Bean
    public AzureOpenAiEmbeddingClient azureOpenAiEmbeddingClient(OpenAIClient openAIClient, AzureOpenAiEmbeddingProperties embeddingProperties) {
        return new AzureOpenAiEmbeddingClient(openAIClient, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions());
    }
}

