/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.anthropic;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionConfiguration;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.ai.autoconfigure.bedrock.anthropic.BedrockAnthropicChatProperties;
import org.springframework.ai.bedrock.anthropic.BedrockAnthropicChatClient;
import org.springframework.ai.bedrock.anthropic.api.AnthropicChatBedrockApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@AutoConfiguration
@ConditionalOnClass(value={AnthropicChatBedrockApi.class})
@EnableConfigurationProperties(value={BedrockAnthropicChatProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(prefix="spring.ai.bedrock.anthropic.chat", name={"enabled"}, havingValue="true")
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockAnthropicChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AnthropicChatBedrockApi anthropicApi(AwsCredentialsProvider credentialsProvider, BedrockAnthropicChatProperties properties, BedrockAwsConnectionProperties awsProperties) {
        return new AnthropicChatBedrockApi(properties.getModel(), credentialsProvider, awsProperties.getRegion(), new ObjectMapper());
    }

    @Bean
    public BedrockAnthropicChatClient anthropicChatClient(AnthropicChatBedrockApi anthropicApi, BedrockAnthropicChatProperties properties) {
        return new BedrockAnthropicChatClient(anthropicApi, properties.getOptions());
    }
}

