/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vertexai;

import org.springframework.ai.autoconfigure.vertexai.VertexAiChatProperties;
import org.springframework.ai.autoconfigure.vertexai.VertexAiConnectionProperties;
import org.springframework.ai.autoconfigure.vertexai.VertexAiEmbeddingProperties;
import org.springframework.ai.vertex.VertexAiChatClient;
import org.springframework.ai.vertex.VertexAiEmbeddingClient;
import org.springframework.ai.vertex.api.VertexAiApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={VertexAiApi.class})
@EnableConfigurationProperties(value={VertexAiConnectionProperties.class, VertexAiChatProperties.class, VertexAiEmbeddingProperties.class})
public class VertexAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAiApi vertexAiApi(VertexAiConnectionProperties connectionProperties, VertexAiEmbeddingProperties embeddingAiProperties, VertexAiChatProperties chatProperties, RestClient.Builder restClientBuilder) {
        return new VertexAiApi(connectionProperties.getBaseUrl(), connectionProperties.getApiKey(), chatProperties.getModel(), embeddingAiProperties.getModel(), restClientBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    public VertexAiChatClient vertexAiChatClient(VertexAiApi vertexAiApi, VertexAiChatProperties chatProperties) {
        return new VertexAiChatClient(vertexAiApi, chatProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    public VertexAiEmbeddingClient vertexAiEmbeddingClient(VertexAiApi vertexAiApi) {
        return new VertexAiEmbeddingClient(vertexAiApi);
    }
}

