/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.azure.openai;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import java.util.List;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiAudioTranscriptionProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiChatProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiConnectionProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiEmbeddingProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiImageOptionsProperties;
import org.springframework.ai.azure.openai.AzureOpenAiAudioTranscriptionModel;
import org.springframework.ai.azure.openai.AzureOpenAiChatModel;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingModel;
import org.springframework.ai.azure.openai.AzureOpenAiImageModel;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={OpenAIClientBuilder.class, AzureOpenAiChatModel.class})
@EnableConfigurationProperties(value={AzureOpenAiChatProperties.class, AzureOpenAiEmbeddingProperties.class, AzureOpenAiConnectionProperties.class, AzureOpenAiImageOptionsProperties.class, AzureOpenAiAudioTranscriptionProperties.class})
public class AzureOpenAiAutoConfiguration {
    private static final String APPLICATION_ID = "spring-ai";

    @Bean
    @ConditionalOnMissingBean(value={OpenAIClient.class, TokenCredential.class})
    public OpenAIClient openAIClient(AzureOpenAiConnectionProperties connectionProperties) {
        if (StringUtils.hasText((String)connectionProperties.getApiKey())) {
            Assert.hasText((String)connectionProperties.getEndpoint(), (String)"Endpoint must not be empty");
            return new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential((KeyCredential)new AzureKeyCredential(connectionProperties.getApiKey())).clientOptions(new ClientOptions().setApplicationId(APPLICATION_ID)).buildClient();
        }
        if (StringUtils.hasText((String)connectionProperties.getOpenAiApiKey())) {
            return new OpenAIClientBuilder().endpoint("https://api.openai.com/v1").credential(new KeyCredential(connectionProperties.getOpenAiApiKey())).clientOptions(new ClientOptions().setApplicationId(APPLICATION_ID)).buildClient();
        }
        throw new IllegalArgumentException("Either API key or OpenAI API key must not be empty");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={TokenCredential.class})
    public OpenAIClient openAIClientWithTokenCredential(AzureOpenAiConnectionProperties connectionProperties, TokenCredential tokenCredential) {
        Assert.notNull((Object)tokenCredential, (String)"TokenCredential must not be null");
        Assert.hasText((String)connectionProperties.getEndpoint(), (String)"Endpoint must not be empty");
        return new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential(tokenCredential).clientOptions(new ClientOptions().setApplicationId(APPLICATION_ID)).buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiChatModel azureOpenAiChatModel(OpenAIClient openAIClient, AzureOpenAiChatProperties chatProperties, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackContext functionCallbackContext) {
        return new AzureOpenAiChatModel(openAIClient, chatProperties.getOptions(), functionCallbackContext, toolFunctionCallbacks);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiEmbeddingModel azureOpenAiEmbeddingModel(OpenAIClient openAIClient, AzureOpenAiEmbeddingProperties embeddingProperties) {
        return new AzureOpenAiEmbeddingModel(openAIClient, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiImageModel azureOpenAiImageClient(OpenAIClient openAIClient, AzureOpenAiImageOptionsProperties imageProperties) {
        return new AzureOpenAiImageModel(openAIClient, imageProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.audio.transcription", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiAudioTranscriptionModel azureOpenAiAudioTranscriptionModel(OpenAIClient openAIClient, AzureOpenAiAudioTranscriptionProperties audioProperties) {
        return new AzureOpenAiAudioTranscriptionModel(openAIClient, audioProperties.getOptions());
    }
}

