/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.openai;

import org.springframework.ai.autoconfigure.openai.OpenAiParentProperties;
import org.springframework.ai.openai.OpenAiAudioSpeechOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.openai.audio.speech")
public class OpenAiAudioSpeechProperties
extends OpenAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.openai.audio.speech";
    public static final String DEFAULT_SPEECH_MODEL = OpenAiAudioApi.TtsModel.TTS_1.getValue();
    private static final Float SPEED = Float.valueOf(1.0f);
    private static final OpenAiAudioApi.SpeechRequest.Voice VOICE = OpenAiAudioApi.SpeechRequest.Voice.ALLOY;
    private static final OpenAiAudioApi.SpeechRequest.AudioResponseFormat DEFAULT_RESPONSE_FORMAT = OpenAiAudioApi.SpeechRequest.AudioResponseFormat.MP3;
    private boolean enabled = true;
    @NestedConfigurationProperty
    private OpenAiAudioSpeechOptions options = OpenAiAudioSpeechOptions.builder().withModel(DEFAULT_SPEECH_MODEL).withResponseFormat(DEFAULT_RESPONSE_FORMAT).withVoice(VOICE).withSpeed(SPEED).build();

    public OpenAiAudioSpeechOptions getOptions() {
        return this.options;
    }

    public void setOptions(OpenAiAudioSpeechOptions options) {
        this.options = options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

