/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.azure;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.search.documents.indexes.SearchIndexClient;
import com.azure.search.documents.indexes.SearchIndexClientBuilder;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.springframework.ai.autoconfigure.vectorstore.azure.AzureVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.azure.AzureVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={EmbeddingModel.class, SearchIndexClient.class, AzureVectorStore.class})
@EnableConfigurationProperties(value={AzureVectorStoreProperties.class})
@ConditionalOnProperty(prefix="spring.ai.vectorstore.azure", value={"url", "api-key", "index-name"})
public class AzureVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SearchIndexClient searchIndexClient(AzureVectorStoreProperties properties) {
        return new SearchIndexClientBuilder().endpoint(properties.getUrl()).credential(new AzureKeyCredential(properties.getApiKey())).buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public AzureVectorStore vectorStore(SearchIndexClient searchIndexClient, EmbeddingModel embeddingModel, AzureVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention) {
        AzureVectorStore vectorStore = new AzureVectorStore(searchIndexClient, embeddingModel, properties.isInitializeSchema(), List.of(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null));
        vectorStore.setIndexName(properties.getIndexName());
        if (properties.getDefaultTopK() >= 0) {
            vectorStore.setDefaultTopK(properties.getDefaultTopK());
        }
        if (properties.getDefaultSimilarityThreshold() >= 0.0) {
            vectorStore.setDefaultSimilarityThreshold(Double.valueOf(properties.getDefaultSimilarityThreshold()));
        }
        return vectorStore;
    }
}

