/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.gemfire;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.autoconfigure.vectorstore.gemfire.GemFireConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.gemfire.GemFireVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.GemFireVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={GemFireVectorStore.class, EmbeddingModel.class})
@EnableConfigurationProperties(value={GemFireVectorStoreProperties.class})
@ConditionalOnProperty(prefix="spring.ai.vectorstore.gemfire", value={"index-name"})
public class GemFireVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={GemFireConnectionDetails.class})
    PropertiesGemFireConnectionDetails gemfireConnectionDetails(GemFireVectorStoreProperties properties) {
        return new PropertiesGemFireConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public GemFireVectorStore gemfireVectorStore(EmbeddingModel embeddingModel, GemFireVectorStoreProperties properties, GemFireConnectionDetails gemFireConnectionDetails, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention) {
        GemFireVectorStore.GemFireVectorStoreConfig.Builder builder = new GemFireVectorStore.GemFireVectorStoreConfig.Builder();
        builder.setHost(gemFireConnectionDetails.getHost()).setPort(gemFireConnectionDetails.getPort()).setIndexName(properties.getIndexName()).setBeamWidth(properties.getBeamWidth()).setMaxConnections(properties.getMaxConnections()).setBuckets(properties.getBuckets()).setVectorSimilarityFunction(properties.getVectorSimilarityFunction()).setFields(properties.getFields()).setSslEnabled(properties.isSslEnabled());
        return new GemFireVectorStore(builder.build(), embeddingModel, properties.isInitializeSchema(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null));
    }

    private static class PropertiesGemFireConnectionDetails
    implements GemFireConnectionDetails {
        private final GemFireVectorStoreProperties properties;

        PropertiesGemFireConnectionDetails(GemFireVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }

        @Override
        public int getPort() {
            return this.properties.getPort();
        }
    }
}

