/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vertexai.embedding;

import com.google.cloud.vertexai.VertexAI;
import java.io.IOException;
import org.springframework.ai.autoconfigure.vertexai.embedding.VertexAiEmbeddingConnectionProperties;
import org.springframework.ai.autoconfigure.vertexai.embedding.VertexAiMultimodalEmbeddingProperties;
import org.springframework.ai.autoconfigure.vertexai.embedding.VertexAiTextEmbeddingProperties;
import org.springframework.ai.vertexai.embedding.VertexAiEmbeddigConnectionDetails;
import org.springframework.ai.vertexai.embedding.multimodal.VertexAiMultimodalEmbeddingModel;
import org.springframework.ai.vertexai.embedding.text.VertexAiTextEmbeddingModel;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={VertexAI.class, VertexAiTextEmbeddingModel.class})
@EnableConfigurationProperties(value={VertexAiEmbeddingConnectionProperties.class, VertexAiTextEmbeddingProperties.class, VertexAiMultimodalEmbeddingProperties.class})
public class VertexAiEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAiEmbeddigConnectionDetails connectionDetails(VertexAiEmbeddingConnectionProperties connectionProperties) {
        Assert.hasText((String)connectionProperties.getProjectId(), (String)"Vertex AI project-id must be set!");
        Assert.hasText((String)connectionProperties.getLocation(), (String)"Vertex AI location must be set!");
        VertexAiEmbeddigConnectionDetails.Builder connectionBuilder = VertexAiEmbeddigConnectionDetails.builder().withProjectId(connectionProperties.getProjectId()).withLocation(connectionProperties.getLocation());
        if (StringUtils.hasText((String)connectionProperties.getApiEndpoint())) {
            connectionBuilder.withApiEndpoint(connectionProperties.getApiEndpoint());
        }
        return connectionBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.vertex.ai.embedding.text", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public VertexAiTextEmbeddingModel textEmbedding(VertexAiEmbeddigConnectionDetails connectionDetails, VertexAiTextEmbeddingProperties textEmbeddingProperties) throws IOException {
        return new VertexAiTextEmbeddingModel(connectionDetails, textEmbeddingProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.vertex.ai.embedding.multimodal", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public VertexAiMultimodalEmbeddingModel multimodalEmbedding(VertexAiEmbeddigConnectionDetails connectionDetails, VertexAiMultimodalEmbeddingProperties multimodalEmbeddingProperties) throws IOException {
        return new VertexAiMultimodalEmbeddingModel(connectionDetails, multimodalEmbeddingProperties.getOptions());
    }
}

