/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;

class DefaultServerHttpMessageConvertersCustomizer
implements ServerHttpMessageConvertersCustomizer {
    private final @Nullable HttpMessageConverters legacyConverters;
    private final Collection<HttpMessageConverter<?>> converters;

    DefaultServerHttpMessageConvertersCustomizer(@Nullable HttpMessageConverters legacyConverters, Collection<HttpMessageConverter<?>> converters) {
        this.legacyConverters = legacyConverters;
        this.converters = converters;
    }

    @Override
    public void customize(HttpMessageConverters.ServerBuilder builder) {
        if (this.legacyConverters != null) {
            this.legacyConverters.forEach(arg_0 -> ((HttpMessageConverters.ServerBuilder)builder).addCustomConverter(arg_0));
        } else {
            builder.registerDefaults();
            this.converters.forEach(converter -> {
                if (converter instanceof KotlinSerializationJsonHttpMessageConverter) {
                    builder.withKotlinSerializationJsonConverter(converter);
                } else {
                    builder.addCustomConverter(converter);
                }
            });
        }
    }
}

