/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.lifecycle;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.testcontainers.lifecycle.TestcontainersLifecycleBeanFactoryPostProcessor;
import org.springframework.boot.testcontainers.lifecycle.TestcontainersLifecycleBeanPostProcessor;
import org.springframework.boot.testcontainers.lifecycle.TestcontainersStartup;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class TestcontainersLifecycleApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Set<ConfigurableApplicationContext> applied = Collections.newSetFromMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ConfigurableApplicationContext applicationContext) {
        Set<ConfigurableApplicationContext> set = applied;
        synchronized (set) {
            if (!applied.add(applicationContext)) {
                return;
            }
        }
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new TestcontainersLifecycleBeanFactoryPostProcessor());
        TestcontainersStartup startup = TestcontainersStartup.get(applicationContext.getEnvironment());
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new TestcontainersLifecycleBeanPostProcessor(beanFactory, startup));
    }
}

