/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;

public final class AuthenticatedPrincipalOAuth2AuthorizedClientRepository
implements OAuth2AuthorizedClientRepository {
    private final AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private final OAuth2AuthorizedClientService authorizedClientService;
    private OAuth2AuthorizedClientRepository anonymousAuthorizedClientRepository = new HttpSessionOAuth2AuthorizedClientRepository();

    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)authorizedClientService, (String)"authorizedClientService cannot be null");
        this.authorizedClientService = authorizedClientService;
    }

    public void setAnonymousAuthorizedClientRepository(OAuth2AuthorizedClientRepository anonymousAuthorizedClientRepository) {
        Assert.notNull((Object)anonymousAuthorizedClientRepository, (String)"anonymousAuthorizedClientRepository cannot be null");
        this.anonymousAuthorizedClientRepository = anonymousAuthorizedClientRepository;
    }

    @Override
    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request) {
        if (this.isPrincipalAuthenticated(principal)) {
            return this.authorizedClientService.loadAuthorizedClient(clientRegistrationId, principal.getName());
        }
        return this.anonymousAuthorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, request);
    }

    @Override
    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        if (this.isPrincipalAuthenticated(principal)) {
            this.authorizedClientService.saveAuthorizedClient(authorizedClient, principal);
        } else {
            this.anonymousAuthorizedClientRepository.saveAuthorizedClient(authorizedClient, principal, request, response);
        }
    }

    @Override
    public void removeAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        if (this.isPrincipalAuthenticated(principal)) {
            this.authorizedClientService.removeAuthorizedClient(clientRegistrationId, principal.getName());
        } else {
            this.anonymousAuthorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal, request, response);
        }
    }

    private boolean isPrincipalAuthenticated(Authentication authentication) {
        return authentication != null && !this.authenticationTrustResolver.isAnonymous(authentication) && authentication.isAuthenticated();
    }
}

