/*
 * Copyright 2002-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.core.io.buffer;

/**
 * Exception that indicates the cumulative number of bytes consumed from a
 * stream of {@link DataBuffer DataBuffer}'s exceeded some pre-configured limit.
 * This can be raised when data buffers are cached and aggregated, for example,
 * {@link DataBufferUtils#join}. Or it could also be raised when data buffers
 * have been released but a parsed representation is being aggregated, for example, async
 * parsing with Jackson, SSE parsing and aggregating lines per event.
 *
 * @author Rossen Stoyanchev
 * @since 5.1.11
 */
@SuppressWarnings("serial")
public class DataBufferLimitException extends IllegalStateException {


	/**
	 * Create an instance with the given message.
	 */
	public DataBufferLimitException(String message) {
		super(message);
	}

	/**
	 * Create an instance with a message and a cause, e.g. {@link OutOfMemoryError}.
	 * @since 6.2.12
	 */
	public DataBufferLimitException(String message, Throwable cause) {
		super(message, cause);
	}

}
