/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 Metadata configuration for a general purpose bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketMetadataConfigurationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<GetBucketMetadataConfigurationResult.Builder, GetBucketMetadataConfigurationResult> {
    private static final SdkField<MetadataConfigurationResult> METADATA_CONFIGURATION_RESULT_FIELD = SdkField
            .<MetadataConfigurationResult> builder(MarshallingType.SDK_POJO)
            .memberName("MetadataConfigurationResult")
            .getter(getter(GetBucketMetadataConfigurationResult::metadataConfigurationResult))
            .setter(setter(Builder::metadataConfigurationResult))
            .constructor(MetadataConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataConfigurationResult")
                    .unmarshallLocationName("MetadataConfigurationResult").build(), RequiredTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(METADATA_CONFIGURATION_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MetadataConfigurationResult metadataConfigurationResult;

    private GetBucketMetadataConfigurationResult(BuilderImpl builder) {
        this.metadataConfigurationResult = builder.metadataConfigurationResult;
    }

    /**
     * <p>
     * The metadata configuration for a general purpose bucket.
     * </p>
     * 
     * @return The metadata configuration for a general purpose bucket.
     */
    public final MetadataConfigurationResult metadataConfigurationResult() {
        return metadataConfigurationResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataConfigurationResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketMetadataConfigurationResult)) {
            return false;
        }
        GetBucketMetadataConfigurationResult other = (GetBucketMetadataConfigurationResult) obj;
        return Objects.equals(metadataConfigurationResult(), other.metadataConfigurationResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketMetadataConfigurationResult")
                .add("MetadataConfigurationResult", metadataConfigurationResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataConfigurationResult":
            return Optional.ofNullable(clazz.cast(metadataConfigurationResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetadataConfigurationResult", METADATA_CONFIGURATION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBucketMetadataConfigurationResult, T> g) {
        return obj -> g.apply((GetBucketMetadataConfigurationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetBucketMetadataConfigurationResult> {
        /**
         * <p>
         * The metadata configuration for a general purpose bucket.
         * </p>
         * 
         * @param metadataConfigurationResult
         *        The metadata configuration for a general purpose bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataConfigurationResult(MetadataConfigurationResult metadataConfigurationResult);

        /**
         * <p>
         * The metadata configuration for a general purpose bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataConfigurationResult.Builder}
         * avoiding the need to create one manually via {@link MetadataConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataConfigurationResult(MetadataConfigurationResult)}.
         * 
         * @param metadataConfigurationResult
         *        a consumer that will call methods on {@link MetadataConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataConfigurationResult(MetadataConfigurationResult)
         */
        default Builder metadataConfigurationResult(Consumer<MetadataConfigurationResult.Builder> metadataConfigurationResult) {
            return metadataConfigurationResult(MetadataConfigurationResult.builder().applyMutation(metadataConfigurationResult)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetadataConfigurationResult metadataConfigurationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketMetadataConfigurationResult model) {
            metadataConfigurationResult(model.metadataConfigurationResult);
        }

        public final MetadataConfigurationResult.Builder getMetadataConfigurationResult() {
            return metadataConfigurationResult != null ? metadataConfigurationResult.toBuilder() : null;
        }

        public final void setMetadataConfigurationResult(MetadataConfigurationResult.BuilderImpl metadataConfigurationResult) {
            this.metadataConfigurationResult = metadataConfigurationResult != null ? metadataConfigurationResult.build() : null;
        }

        @Override
        public final Builder metadataConfigurationResult(MetadataConfigurationResult metadataConfigurationResult) {
            this.metadataConfigurationResult = metadataConfigurationResult;
            return this;
        }

        @Override
        public GetBucketMetadataConfigurationResult build() {
            return new GetBucketMetadataConfigurationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
