/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketAbacResponse extends S3Response implements
        ToCopyableBuilder<GetBucketAbacResponse.Builder, GetBucketAbacResponse> {
    private static final SdkField<AbacStatus> ABAC_STATUS_FIELD = SdkField
            .<AbacStatus> builder(MarshallingType.SDK_POJO)
            .memberName("AbacStatus")
            .getter(getter(GetBucketAbacResponse::abacStatus))
            .setter(setter(Builder::abacStatus))
            .constructor(AbacStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbacStatus")
                    .unmarshallLocationName("AbacStatus").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABAC_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AbacStatus abacStatus;

    private GetBucketAbacResponse(BuilderImpl builder) {
        super(builder);
        this.abacStatus = builder.abacStatus;
    }

    /**
     * <p>
     * The ABAC status of the general purpose bucket.
     * </p>
     * 
     * @return The ABAC status of the general purpose bucket.
     */
    public final AbacStatus abacStatus() {
        return abacStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(abacStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAbacResponse)) {
            return false;
        }
        GetBucketAbacResponse other = (GetBucketAbacResponse) obj;
        return Objects.equals(abacStatus(), other.abacStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketAbacResponse").add("AbacStatus", abacStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbacStatus":
            return Optional.ofNullable(clazz.cast(abacStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AbacStatus", ABAC_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBucketAbacResponse, T> g) {
        return obj -> g.apply((GetBucketAbacResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3Response.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketAbacResponse> {
        /**
         * <p>
         * The ABAC status of the general purpose bucket.
         * </p>
         * 
         * @param abacStatus
         *        The ABAC status of the general purpose bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abacStatus(AbacStatus abacStatus);

        /**
         * <p>
         * The ABAC status of the general purpose bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AbacStatus.Builder} avoiding the need to
         * create one manually via {@link AbacStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AbacStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #abacStatus(AbacStatus)}.
         * 
         * @param abacStatus
         *        a consumer that will call methods on {@link AbacStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abacStatus(AbacStatus)
         */
        default Builder abacStatus(Consumer<AbacStatus.Builder> abacStatus) {
            return abacStatus(AbacStatus.builder().applyMutation(abacStatus).build());
        }
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private AbacStatus abacStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAbacResponse model) {
            super(model);
            abacStatus(model.abacStatus);
        }

        public final AbacStatus.Builder getAbacStatus() {
            return abacStatus != null ? abacStatus.toBuilder() : null;
        }

        public final void setAbacStatus(AbacStatus.BuilderImpl abacStatus) {
            this.abacStatus = abacStatus != null ? abacStatus.build() : null;
        }

        @Override
        public final Builder abacStatus(AbacStatus abacStatus) {
            this.abacStatus = abacStatus;
            return this;
        }

        @Override
        public GetBucketAbacResponse build() {
            return new GetBucketAbacResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
